/*
 * Decompiled with CFR 0.152.
 */
package sh.zoltus.parrots;

import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import sh.zoltus.parrots.Loader;
import sh.zoltus.parrots.ParrotHandler;

public class ParrotPet {
    private final Loader plugin = Loader.getPlugin();
    private final Player p;
    private Shoulder shoulder;
    private final Parrot parrot;

    public ParrotPet(Player p, Parrot.Variant color, Shoulder side) {
        this.p = p;
        this.shoulder = Shoulder.valueOf(this.plugin.getConfig().get("Config.DefaultSide").toString().toUpperCase());
        p.setShoulderEntityRight(null);
        p.setShoulderEntityLeft(null);
        this.parrot = (Parrot)p.getWorld().spawnEntity(p.getLocation(), EntityType.PARROT);
        this.parrot.remove();
        this.parrot.setSilent(((Boolean)this.plugin.getConfig().get("Config.isSilent")).booleanValue());
        this.parrot.setCustomName(p.getUniqueId() + "Parrot");
        this.parrot.setCustomNameVisible(false);
        this.parrot.setVariant(color);
        this.parrot.setSitting(true);
        this.parrot.setOwner((AnimalTamer)p);
        this.parrot.setTamed(true);
        this.parrot.setAI(true);
        ParrotHandler.parrotPets.add(this);
        this.setParrot();
    }

    public void setParrot() {
        this.p.setShoulderEntityRight(null);
        this.p.setShoulderEntityLeft(null);
        if (this.parrot == null || this.p.isFlying()) {
            return;
        }
        switch (this.shoulder) {
            case RIGHT: {
                this.p.setShoulderEntityRight((Entity)this.parrot);
                break;
            }
            case LEFT: {
                this.p.setShoulderEntityLeft((Entity)this.parrot);
                break;
            }
            case BOTH: {
                this.p.setShoulderEntityRight((Entity)this.parrot);
                this.p.setShoulderEntityLeft((Entity)this.parrot);
            }
        }
    }

    public void setShoulder(Shoulder newShoulder) {
        this.shoulder = newShoulder;
        this.setParrot();
    }

    public void setVariant(Parrot.Variant variant) {
        this.parrot.setVariant(variant);
        this.setParrot();
    }

    public void removeParrot() {
        ParrotHandler.removeParrot(this.getOwner());
    }

    public Player getOwner() {
        return this.p;
    }

    public Parrot getParrot() {
        return this.parrot;
    }

    public Shoulder getShoulder() {
        return this.shoulder;
    }

    static enum Shoulder {
        LEFT,
        RIGHT,
        BOTH;

    }
}

